import oscP5.*;
import netP5.*;
import themidibus.*;
MidiBus myBus;

OscP5 oscP5;
NetAddress myRemoteLocation;
float GyroX, GyroY, GyroZ;
float OrientationM11, OrientationM12, OrientationM13, OrientationM21, OrientationM22, OrientationM23, OrientationM31, OrientationM32, OrientationM33;
float AccelX, AccelY, AccelZ;
float MagnX, MagnY, MagnZ;
float ValueGyroX, ValueGyroY, ValueGyroZ;
float Slider1, Controller1, Controller2;
boolean AccelXState = false;
boolean lastAccelXState = false;
boolean AccelYState = false;
boolean lastAccelYState = false;

void setup() {

  size(800, 400);
  MidiBus.list(); // Liste aller Geräte ausgeben
  myBus = new MidiBus(this, -1, "Bus 1");
  
  oscP5 = new OscP5(this, 8001);
  myRemoteLocation = new NetAddress("10.128.129.108", 8100);
  oscP5.plug(this, "Gyro", "/gyrosc/gyro");
  oscP5.plug(this, "OrientationMatrix", "/gyrosc/rmatrix");
  oscP5.plug(this, "Accelerometer", "/gyrosc/accel");
  oscP5.plug(this, "Magnetometer", "/gyrosc/mag");
  oscP5.plug(this, "SyntienS", "/syntien/basic/1/slider1");
  oscP5.plug(this, "SyntienC", "/syntien/basic/1/button1");
}

public void Gyro(float X, float Y, float Z) {

  GyroX = X;
  GyroY = Y;
  GyroZ = Z;
}

public void OrientationMatrix(float m11, float m12, float m13, float m21, float m22, float m23, float m31, float m32, float m33) {
  OrientationM11 = m11;
  OrientationM12 = m12;
  OrientationM13 = m13;
  OrientationM21 = m21;
  OrientationM22 = m22;
  OrientationM23 = m23;
  OrientationM31 = m31;
  OrientationM32 = m32;
  OrientationM33 = m33;
}

public void Accelerometer(float X, float Y, float Z) {
  AccelX = X;
  AccelY = Y;
  AccelZ = Z;
}

public void Magnetometer(float X, float Y, float Z) {
  MagnX = X;
  MagnY = Y;
  MagnZ = Z;
}

public void SyntienS(float x) {
  Slider1 = x;
}

public void SyntienC(int x, int y) {
  Controller1 = x;
  Controller2 = y;
}

void draw() {
  background(0);
  fill(255);
  frameRate(5);
  
  // sends the message to control the synth
      sendMessageGyroX();
      //sendMessageGyroY();
      //sendMessageGyroZ();
      //sendMessageM11();
      //sendMessageM12();
      //sendMessageM13();
      //sendMessageM21();
      //sendMessageM22();
      //sendMessageM23();
      //sendMessageM31();
      //sendMessageM32();
      //sendMessageM33();
      //sendMessageAccelX();
      //sendMessageAccelY();
      //sendMessageAccelZ();
      //sendMessageMagnX();
      //sendMessageMagnY();
      //sendMessageMagnZ();*/
  //println(GyroZ);
  
 
  if(AccelX > 0.3 || AccelX < -0.3){
    AccelXState = true;
    println("noteON");
  }
  else{
    AccelXState = false;
  }
  if(AccelXState != lastAccelXState){
    if(AccelXState == true){
      myBus.sendNoteOn(2, 64, 127);
      println("NoteOn");
    }
    else{
      myBus.sendNoteOff(2, 64, 127);
      println("NoteOff");
    }
  }
  lastAccelXState = AccelXState;
  
  
  //Syntien Controller
    if(Controller1 == 1){
    myBus.sendNoteOn(2, 64, 127);
    //println("ON");
  }
  else{
    myBus.sendNoteOff(2, 64, 127);
  }
  
}
