/* Dieses Script blendet jeweils einen von
   mehreren HTML-Tags ein, die anderen aus.
   Dazu geht es durch alle Tags mit der Klasse
   "ascii-machine-2", listet alle darin ent-
   haltenen Elemente (children) auf und aktiviert
   bzw. deaktiviert sie der Reihe nach.
   Dazu wird ein Zähler (count2) mit der
   Reihenfolge der Elemente verglichen.
 */

const freq2 = 300 // Millisekunden

const machines2 = document.querySelectorAll('.ascii-machine-2')
let count2 = 0

setInterval(() => {
  for (const machine of machines2) {
    const scenes = [...machine.children]
    scenes.forEach((scene, i) => {
      if (i === count2 % scenes.length) {
        scene.setAttribute('style', `display: block;`)
      } else {
        scene.setAttribute('style', `display: none;`)
      }
    })
  }
  count2 += 1
}, freq2)
